cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

all<-read.table('gene_counts.txt',row.names=1)
row.names(all) <- c("hiF","he6","n24","niPS","p24","piPS")
n_path <- c("hiF","he6","n24","niPS")
p_path <- c("hiF","he6","p24","piPS")
naive <- all[n_path,]
primed <- all[p_path,]

pdf("Figure5.pdf",width=3.5,height=3.5)
plot((naive[,1]+naive[,2]+naive[,3]),type="l",lwd=2,main="",col=cccol[1],xlab=NA,axes=F,ylab="Covered gene number",ylim=c(0,4500))
axis(side=2)
axis(side=1,1:4,c("hiF-T","6d","24d","iPS-C"),las=2);box();
lines((primed[,1]+primed[,2]+primed[,3]),type="l",lty=2,lwd=2,col=cccol[1])
lines((naive[,2]+naive[,5]+naive[,8]),type="l",lwd=2,col=cccol[3])
lines((primed[,2]+primed[,5]+primed[,8]),type="l",lty=2,lwd=2,col=cccol[3])
lines((naive[,2]),type="l",lwd=2,col=cccol[2])
lines((primed[,2]),type="l",lty=2,lwd=2,col=cccol[2])
dev.off()

pdf("Figure5_legend.pdf",width=5,height=5)
plot(seq(1,8),seq(1,8),type="n")
legend("topright",c("H3K4me3","H3K27me3","Bivalent"),lwd=2,lty=1,col=c(cccol[1],cccol[3],cccol[2]),bty="n")
legend("topleft",c("naive","primed"),lwd=2,lty=c(1,2),col=cccol[1],bty="n")
text(2,2,c("H3K4me3"),col=cccol[1])
text(4,2,c("H3K27me3"),col=cccol[3])
text(6,2,c("Bivalent"),col=cccol[2])
dev.off()
